package UI;

import Back.Tree;
import GraphicThreads.*;
import javafx.application.Application;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class Main extends Application implements EventHandler<ActionEvent> {

    public Main() {
    }

    Tree tree1, tree2;
    int width = 960;
    int height = 960;
    Button pause,play,faster,slower, save, load, cut, join, move, skip, balance, ok, compare;
    MyPane pane;
    BorderPane bp;
    Scene scene;
    TextField input, input2;
    VBox buttons;


    @Override
    public void start(Stage primaryStage) throws InterruptedException {
        generateButtons();

        //pane = new myPane(new Ostatne.Tree("tree1"), null); uz rovno nacitany prvy strom
        pane = new MyPane(null, null, width, height, this);
        pane.update();
        pane.setMinHeight(height);
        pane.setMinWidth(width);

        bp = new BorderPane();
        bp.setLeft(buttons);
        bp.setRight(pane);

        menuButtons();

        scene = new Scene(bp,width+200,height);
        primaryStage.setTitle("STROMY");
        primaryStage.setScene(scene);
        primaryStage.show();
        primaryStage.setResizable(false);

    }

    /**
     * zadefinuje vsetky tlacitka a UI veci
     */
    public void generateButtons(){
        pause = new Button();
        pause.setText("pause");
        pause.setOnAction(this);

        skip = new Button();
        skip.setText("skip");
        skip.setOnAction(this);

        faster = new Button();
        faster.setText("+");
        faster.setOnAction(this);

        slower = new Button();
        slower.setText("-");
        slower.setOnAction(this);

        play = new Button();
        play.setText("play");
        play.setOnAction(this);

        save = new Button();
        save.setText("save");
        save.setOnAction(this);

        load = new Button();
        load.setText("load");
        load.setOnAction(this);

        cut = new Button();
        cut.setText("cut");
        cut.setOnAction(this);

        move = new Button();
        move.setText("move");
        move.setOnAction(this);

        join = new Button();
        join.setText("join");
        join.setOnAction(this);

        balance = new Button();
        balance.setText("balance");
        balance.setOnAction(this);

        ok = new Button();
        ok.setText("ok");
        ok.setOnAction(this);

        compare = new Button();
        compare.setText("compare");
        compare.setOnAction(this);

        input = new TextField();
        input2 = new TextField();

        buttons = new VBox(10);
        buttons.setPadding(new Insets(10,10,10,10));
    }


    /**
     * nastavi tlacitka ktore sa pouzivaju pri animacii
     */
    public void animationButtons(){
        buttons.getChildren().clear();
        buttons.getChildren().addAll(pause,faster,slower,play, skip);
    }

    /**
     * nastavi tlacitka ktore su sucastou menu
     */
    public void menuButtons(){
        buttons.getChildren().clear();
        if ( pane.getTree1() == null ){
            Label label = new Label("Enter file name");
            buttons.getChildren().addAll(label, input, load);
            return;
        }

        buttons.getChildren().addAll(new Label("Menu"), load, cut, move, join, save, balance, compare);
    }

    /**
     * nastavi label so spravou a tlacidlo ok ktore caka na pouzivatela
     * ktory ho stlaci po precitani informacie
     */
    public void ok(String label){
        buttons.getChildren().clear();
        Label l = new Label(label);
        buttons.getChildren().addAll(l, ok);
    }
    /**
     * loadovanie druheho stromu, zatial iba pre compare a pre join
     */
    private void loadSecond( String next_thread ){
        if ( input.getText().equals("")) {
            Label label = new Label("Enter filename of second tree");
            buttons.getChildren().clear();
            buttons.getChildren().addAll(label, input);
            switch (next_thread){ // robim to cez switch keby nahodou som to chcel pouzit este pre dalsie
                case "join":
                    buttons.getChildren().add(join);
                    break;
                case "compare":
                    buttons.getChildren().add(compare);
                    break;
            }

        } else {
            pane.setThread( new LoadThread(pane, input.getText(), next_thread));
            input.clear();
            animationButtons();
        }
    }

    /**
     * handle ktory spracovava kliknutie na tlacitka
     * @param actionEvent event udalosti
     */
    @Override
    public void handle(ActionEvent actionEvent) {

        if(actionEvent.getSource() == skip){
            pane.getThread().skip();
            play.fire();
        }

        if(actionEvent.getSource() == faster){
            pane.getThread().setSleepTime(false);
        }

        if(actionEvent.getSource() == slower){
            pane.getThread().setSleepTime(true);
        }

        if(actionEvent.getSource() == pause){
            pane.getThread().suspend();
        }

        if(actionEvent.getSource() == play){
            GraphicThread thread = pane.getThread();

            if (thread.getState() == Thread.State.NEW) {
                thread.start();
            }

            if ( thread.getState()  == Thread.State.TIMED_WAITING)
                thread.resume();
            }

        if(actionEvent.getSource() == save){
            if ( input.getText().equals("")) {
                Label label = new Label("Enter file name");
                buttons.getChildren().clear();
                buttons.getChildren().addAll(label, input, save);
            } else {
                pane.getTree1().save(input.getText());
                input.clear();
                ok("Ostatne.Tree has been save successfully");
            }
        }

        if(actionEvent.getSource() == load){
            if ( input.getText().equals("")) {
                Label label = new Label("Enter file name");
                buttons.getChildren().clear();
                buttons.getChildren().addAll(label, input, load);
            } else {
                pane.setTree1(null);
                pane.update();
                pane.setThread( new LoadThread(pane, input.getText(), null));
                input.clear();
                animationButtons();
            }

        }

        if(actionEvent.getSource() == cut){
            if ( input.getText().equals("")) {
                Label label = new Label("Enter node you want to cut");
                buttons.getChildren().clear();
                buttons.getChildren().addAll(label, input, cut);

            } else {
                pane.setThread( new CutThread(pane, input.getText()));
                input.clear();
                animationButtons();
            }
        }

        if(actionEvent.getSource() == join){
            loadSecond("join");
            /*
            if ( input.getText().equals("")) {
                Label label = new Label("Enter filename of second tree");
                buttons.getChildren().clear();
                buttons.getChildren().addAll(label, input, join);
            } else {
                pane.setThread( new GraphicThreads.LoadThread(pane, input.getText(), "join"));
                input.clear();
                animationButtons();
            }

             */
        }

        if(actionEvent.getSource() == move){
            if ( input.getText().equals("") |  input2.getText().equals("")) {
                Label label2 = new Label("Enter node you want to move");
                Label label = new Label("Enter where you want to move it");
                buttons.getChildren().clear();
                buttons.getChildren().addAll(label2, input, label, input2, move);
            } else {
                pane.setThread( new MoveThread(pane, input2.getText(), input.getText()));
                input.clear();
                input2.clear();
                animationButtons();
            }
        }

        if(actionEvent.getSource() == balance){
            pane.setThread(new BalanceThread(pane));
            animationButtons();
        }


        if(actionEvent.getSource() == compare){
            loadSecond("compare");
        }


        if(actionEvent.getSource() == ok){
            pane.end();
            menuButtons();
        }

    }








}










